<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\WorkloadManager\Resource;

use Google\Service\WorkloadManager\WorkloadmanagerEmpty;
use Google\Service\WorkloadManager\WriteInsightRequest;
use Google\Service\WorkloadManager\WriteInsightResponse;

/**
 * The "insights" collection of methods.
 * Typical usage is:
 *  <code>
 *   $workloadmanagerService = new Google\Service\WorkloadManager(...);
 *   $insights = $workloadmanagerService->projects_locations_insights;
 *  </code>
 */
class ProjectsLocationsInsights extends \Google\Service\Resource
{
  /**
   * Delete the data insights from workload manager data warehouse.
   * (insights.delete)
   *
   * @param string $name Required. The system id of the SAP system resource to
   * delete. Formatted as
   * projects/{project}/locations/{location}/sapSystems/{sap_system_id}
   * @param array $optParams Optional parameters.
   *
   * @opt_param string requestId Optional. An optional request ID to identify
   * requests. Specify a unique request ID so that if you must retry your request,
   * the server will know to ignore the request if it has already been completed.
   * The server will guarantee that for at least 60 minutes since the first
   * request. For example, consider a situation where you make an initial request
   * and the request times out. If you make the request again with the same
   * request ID, the server can check if original operation with the same request
   * ID was received, and if so, will ignore the second request. This prevents
   * clients from accidentally creating duplicate commitments. The request ID must
   * be a valid UUID with the exception that zero UUID is not supported
   * (00000000-0000-0000-0000-000000000000).
   * @return WorkloadmanagerEmpty
   * @throws \Google\Service\Exception
   */
  public function delete($name, $optParams = [])
  {
    $params = ['name' => $name];
    $params = array_merge($params, $optParams);
    return $this->call('delete', [$params], WorkloadmanagerEmpty::class);
  }
  /**
   * Write the data insights to workload manager data warehouse.
   * (insights.writeInsight)
   *
   * @param string $location Required. The GCP location. The format is:
   * projects/{project}/locations/{location}.
   * @param WriteInsightRequest $postBody
   * @param array $optParams Optional parameters.
   * @return WriteInsightResponse
   * @throws \Google\Service\Exception
   */
  public function writeInsight($location, WriteInsightRequest $postBody, $optParams = [])
  {
    $params = ['location' => $location, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('writeInsight', [$params], WriteInsightResponse::class);
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ProjectsLocationsInsights::class, 'Google_Service_WorkloadManager_Resource_ProjectsLocationsInsights');
